#include "bits/stdc++.h"


using ll = long long;
using ld = long double;
using namespace std;

#define FAST_IO ios_base::sync_with_stdio(false); cin.tie(0); cout.tie(0)


constexpr int MAXN = 2e5 + 10, INF = 1e9 + 10;


int add(int a, int b, int mod) {
	if (a + b > mod) return a + b - mod;
	return a + b;
}


int sub(int a, int b, int mod) {
	if (a - b < 0) return a - b + mod;
	return a - b;
}


int mult(int a, int b, int mod) {
	return 1ll * a * b % mod;
}


template <class T>
struct SparceTable {
	vector<int> log2;
	vector<vector<T> > st;


	SparceTable(vector<T>& base) {
		int n = base.size();
		log2.resize(n + 1, -1);
		st.resize(n + 1);
		log2[1] = 0;
		for (int i = 2; i <= n; ++i) log2[i] = log2[i / 2] + 1;
		st[0] = base;
		for (int size = 1; size <= log2[n]; ++size) {
			st[size].resize(n - (1 << size) + 1);
			for (int ind = 0; ind < n - (1 << size) + 1; ++ind) {
				st[size][ind] = min(st[size - 1][ind], st[size - 1][ind + (1 << (size - 1))]);
			}
		}
	}

	T get_min(int l, int r) {
		int log = log2[r - l];
		return min(st[log][l], st[log][r - (1 << log)]);
	}
};


struct Hasher {
	vector<int> hash, rev_hash;
	vector<int> pw;
	int mod, p;

	Hasher(string& s) {
		int n = s.size();
		hash.resize(n + 1, 0);
		rev_hash.resize(n + 1, 0);
		pw.resize(n + 1, 1);
		for (int i = 0; i < n; ++i) {
			pw[i + 1] = mult(pw[i], p, mod);
			hash[i + 1] = add(mult(hash[i], p, mod), s[i], mod);
			rev_hash[i + 1] = add(mult(rev_hash[i], p, mod), s[n - i - 1], mod);
		}
	}


	int get_hash(int l, int r) {
		return sub(hash[r], mult(hash[l], pw[r - l], mod), mod);
	}

	int get_reversed_hash(int l, int r) {
		return 0;
	}
};


bool is_palindrome(int x) {
	if (x < 10) return true;
	if (x < 100) return x % 11 == 0;
	return x % 10 == x / 100;
}


int main() {
	FAST_IO;
	int t;
	for (cin >> t; t; --t) {
		int x, y;
		cin >> x >> y;
		if (x == y) {
			cout << "0\n";
			continue;
		}
		vector<int> dels;
		int d = y - x;
		int i = 1;
		while (i * i < d) {
			if (d % i == 0) {
				dels.push_back(i);
				dels.push_back(d / i);
			}
			i += 1;
		}
		if (i * i == d) dels.push_back(i);
		int best = 1e9;
		for (auto dd : dels) {
			if (x >= dd) best = min(best, x - dd);
		}
		cout << best << '\n';
	}
}
